import Typography from '@mui/material/Typography';
import Paper, { PaperProps } from '@mui/material/Paper';

// ----------------------------------------------------------------------

interface Props extends PaperProps {
  query?: string;
}

export default function SearchNotFound({ query, sx, ...other }: Props) {
  return query ? (
    <Paper
      sx={{
        boxShadow: 'none',
        textAlign: 'center',
        ...sx,
      }}
      {...other}
    >
      <Typography variant="h6" gutterBottom>
        Non trouvé
      </Typography>

      <Typography variant="body2">
        Aucun résultat trouvé pour &nbsp;
        <strong>&quot;{query}&quot;</strong>.
        <br /> Essayez de vérifier les fautes de frappe ou d&apos;utiliser des mots complets.
      </Typography>
    </Paper>
  ) : (
    <Typography variant="body2" sx={sx}>
      Veuillez entrer des mots-clés
    </Typography>
  );
}
