import * as Yup from 'yup';

export const absenceValidationSchema = Yup.object().shape({
  usager: Yup.mixed()
    .test('required', 'L\'usager est obligatoire', function(value) {
      if (!value) return false;
      if (typeof value === 'number') return true;
      if (value && typeof value === 'object' && 'id' in value) return true;
      return false;
    }),
  dateDebut: Yup.string().required('La date de début est requise'),
  dateFin: Yup.string()
    .required('La date de fin est requise')
    .test('is-after-start', 'La date de fin doit être après la date de début', function(value) {
      const { dateDebut } = this.parent;
      if (!dateDebut || !value) return true;
      return new Date(value) >= new Date(dateDebut);
    }),
  sensAR: Yup.array()
    .of(Yup.string())
    .min(1, 'Au moins un trajet doit être sélectionné')
    .required('Le sens est requis'),
  modeReception: Yup.string().required('Le mode de réception est requis'),
  previentLe: Yup.string().required('La date de prévention est requise'),
  par: Yup.string().required('Le champ "par" est requis'),
  observation: Yup.string(),
  comment: Yup.string(),
}); 
