import { IAgent } from '@/shared/types/agent';

import { TableConfig, useTableManager } from '@/hooks/use-table-manager';
import { _agents, DEFAULT_AGENT_TABLE_HEAD } from '@/shared/_mock/_agent';

const agentConfig: TableConfig<IAgent> = {
  type: 'agent',
  initialData: _agents,
  defaultTableHead: DEFAULT_AGENT_TABLE_HEAD,
};

export function useAgentTable() {
  return useTableManager<IAgent>(agentConfig);
}