import * as Yup from 'yup';

export const agentSchema = Yup.object().shape({
  lastName: Yup.string()
    .required('Le nom est requis')
    .min(2, 'Le nom doit contenir au moins 2 caractères'),
  firstName: Yup.string()
    .required('Le prénom est requis')
    .min(2, 'Le prénom doit contenir au moins 2 caractères'),
  birthDate: Yup.date()
    .required('La date de naissance est requise')
    .max(new Date(), 'La date de naissance ne peut pas être dans le futur'),
  birthPlace: Yup.string()
    .required('Le lieu de naissance est requis'),
  address: Yup.object().shape({
    address: Yup.string().required('L\'adresse est requise'),
    lat: Yup.number(),
    lng: Yup.number(),
  }),
  phone: Yup.string()
    .required('Le numéro de téléphone est requis')
    .matches(/^[0-9+\s-]{10,}$/, 'Format de téléphone invalide'),
  personalEmail: Yup.string()
    .email('Format d\'email invalide'),
  email: Yup.string()
    .required('L\'email est requis')
    .email('Format d\'email invalide'),
  password: Yup.string()
    .when('$isNew', {
      is: true,
      then: (schema) => schema
        .required('Le mot de passe est requis')
        .min(8, 'Le mot de passe doit contenir au moins 8 caractères')
        .matches(/[A-Z]/, 'Le mot de passe doit contenir au moins une majuscule')
        .matches(/[a-z]/, 'Le mot de passe doit contenir au moins une minuscule')
        .matches(/[0-9]/, 'Le mot de passe doit contenir au moins un chiffre'),
      otherwise: (schema) => schema
        .min(8, 'Le mot de passe doit contenir au moins 8 caractères')
        .matches(/[A-Z]/, 'Le mot de passe doit contenir au moins une majuscule')
        .matches(/[a-z]/, 'Le mot de passe doit contenir au moins une minuscule')
        .matches(/[0-9]/, 'Le mot de passe doit contenir au moins un chiffre'),
    }),
  socialSecurityNumber: Yup.string()
    .required('Le numéro de sécurité sociale est requis'),
  agentId: Yup.string()
    .required('L\'identifiant agent est requis'),
  agency: Yup.string()
    .required('L\'agence est requise'),
  department: Yup.string()
    .required('Le département est requis'),
  team: Yup.string(),
  contractType: Yup.string()
    .required('Le type de contrat est requis'),
  status: Yup.string()
    .required('Le statut est requis'),

  role: Yup.string()
    .required('Le rôle est requis'),
}); 