import { FormFieldType } from '@/shared/types/common';
import { IAgent } from '@/shared/types/agent';
import { _AGENT_STATUS } from '@/shared/_mock/_agent';
import { _teams } from '@/shared/_mock/_equipes';
import { faBuilding, faBuildingUser, faCalendar, faClock, faEnvelope, faFileContract, faHistory, faHome, faIdCard, faListCheck, faLocationDot, faLock, faPhone, faSignature, faSitemap, faUser, faUserShield, faUsers } from '@fortawesome/free-solid-svg-icons';

export const CONTRACT_TYPES = [
  { value: 'CDI', label: 'CDI' },
  { value: 'CDD', label: 'CDD' },
  { value: 'Intérim', label: 'Intérim' },
];

export const AGENT_ROLES = [
  { value: 'aucun', label: 'Aucun' },
  { value: 'admin', label: 'Admin' },
  { value: 'manager', label: 'Manager' },
  { value: 'agent', label: 'Agent' },
  { value: 'auditeur', label: 'Auditeur' },
  { value: 'superviseur', label: 'Superviseur' },
];

export const PERMISSIONS = [
  { value: 'read', label: 'Lire' },
  { value: 'write', label: 'Ecrire' },
  { value: 'edit', label: 'Modifier' },
  { value: 'delete', label: 'Supprimer' },
];

export const TEAMS_OPTIONS = _teams.map(team => ({
  value: team.id,
  label: `${team.name} (${team.id})`
}));

export const personalInfoFields: FormFieldType<IAgent>[] = [
  { name: 'lastName', label: 'Nom', type: 'text', required: true, icon: faSignature },
  { name: 'firstName', label: 'Prénom', type: 'text', required: true, icon: faUser },
  { name: 'birthDate', label: 'Date de naissance', type: 'date', required: true, icon: faCalendar },
  { name: 'birthPlace', label: 'Lieu de naissance', type: 'text', required: true, icon: faLocationDot },
  { name: 'address', label: 'Adresse', type: 'address', required: true, icon: faHome },
  { name: 'phone', label: 'Téléphone', type: 'text', required: true, icon: faPhone },
  { name: 'personalEmail', label: 'E-mail', type: 'text', icon: faEnvelope },
];

export const professionalInfoFields: FormFieldType<IAgent>[] = [
  { name: 'agentId', label: 'Identifiant Agent', type: 'text', required: true, icon: faBuildingUser },
  { name: 'agency', label: 'Agence', type: 'text', required: true, icon: faBuilding },
  { name: 'email', label: 'E-mail professionnel', type: 'text', required: true, icon: faEnvelope },
  { name: 'password', label: 'Mot de passe', type: 'password', required: true,  showPassword: true },
  { name: 'socialSecurityNumber', label: 'Numéro de sécurité sociale', type: 'text', required: true, icon: faIdCard },
  { name: 'department', label: 'Département', type: 'text', required: true, icon: faSitemap },
  { name: 'team', label: 'Équipe', type: 'select', options: TEAMS_OPTIONS, required: false, icon: faUsers },
  { name: 'contractType', label: 'Type de contrat', type: 'select', options: CONTRACT_TYPES, required: true, icon: faFileContract },
  { name: 'status', label: 'Statut', type: 'select', options: _AGENT_STATUS, required: true },
];

export const rolePermissionFields: FormFieldType<IAgent>[] = [
  { name: 'roles', label: 'Rôle assigné', type: 'select', options: AGENT_ROLES, required: true, icon: faUserShield },
  { name: 'permissions', label: 'Permissions', type: 'select', options: PERMISSIONS, required: true, icon: faListCheck },
];