import { FormFieldType } from '@/shared/types/common';
import { IEquipe, TeamRequest } from '@/shared/types/equipe';
import { 
  faUsers, 
  faUserTie, 
  faBuilding, 
  faMapMarker, 
  faIndustry,
  faNoteSticky, 
  faUserGroup
} from '@fortawesome/free-solid-svg-icons';

export const formFields = (
  teamLeaderOptions: { value: string; label: string }[],
  departmentOptions: { value: string; label: string }[]
): FormFieldType<TeamRequest>[] => [
  {
    name: 'name',
    label: "Nom d'équipe",
    type: 'text',
    placeholder: 'Entrez le nom',
    required: true,
    icon: faUsers,
  },
  {
    name: 'teamLeaderId',
    label: "Chef d'équipe",
    type: 'combobox',
    placeholder: 'Sélectionnez un responsable',
    required: true,
    icon: faUserTie,
    options: teamLeaderOptions,
  },
  {
    name: 'department',
    label: 'Département',
    type: 'combobox',
    placeholder: 'Sélectionnez un département',
    required: true,
    icon: faMapMarker,
    options: departmentOptions,
  },
  {
    name: 'creationDate',
    label: 'Date de création',
    type: 'date',
    required: true,
  },
  {
    name: 'collaborators',
    label: 'Membres de l\'équipe',
    type: 'multiple',
    placeholder: 'Sélectionnez les agents',
    required: true,
    icon: faUserGroup,
    options: teamLeaderOptions, 
  
  },
];