import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { IRole } from '@/shared/types/role';
import { INITIAL_ROLE_DATA } from '@/shared/_mock/_roles';


const roleConfig: TabConfig<IRole> = {
  type: 'role',
  listTitle: 'Liste des rôles',
  newItemTitle: 'Nouveau rôle',
  initialData: INITIAL_ROLE_DATA,
  getItemCode: (role) => role.id,
};

export function useRoleTabs() {
  return useTabsManager<IRole>(roleConfig);
}