import * as yup from 'yup';

export const agencySchema = yup.object().shape({
  sectorId: yup.string().required('Le secteur est requis'),
  name: yup.string().required('Le nom est requis'),
  mapAdresse: yup.object().shape({
    address: yup.string(),
    lat: yup.number(),
    lng: yup.number(),
    city: yup.string(),
    postalCode: yup.string(),
    country: yup.string(),
    formattedAddress: yup.string()
  }).required("L'adresse est requise"),
  description: yup.string()
});
