import React from 'react';
import { Box, Card, CardHeader, CircularProgress, Table, TableBody, TableCell, TableContainer, TableHead, TableRow, Typography } from '@mui/material';
import { TripListPageable } from '@/shared/types/amendment';

interface AvenantTripsProps {
  trips: TripListPageable | null;
  loading: boolean;
}

export default function AvenantTrips({ trips, loading }: AvenantTripsProps) {
  if (loading) {
    return (
      <Box sx={{ display: 'flex', justifyContent: 'center', p: 3 }}>
        <CircularProgress />
      </Box>
    );
  }

  if (!trips || !trips.content || trips.content.length === 0) {
    return (
      <Box sx={{ p: 3, textAlign: 'center' }}>
        <Typography variant="body1">Aucun trajet associé à cet avenant</Typography>
      </Box>
    );
  }

  return (
    <Card>
      <CardHeader title="Trajets associés" />
      <TableContainer>
        <Table>
          <TableHead>
            <TableRow>
              <TableCell>ID</TableCell>
              <TableCell>Direction</TableCell>
              <TableCell>Distance (km)</TableCell>
              <TableCell>Durée (min)</TableCell>
              <TableCell>Nombre de passagers</TableCell>
            </TableRow>
          </TableHead>
          <TableBody>
            {trips.content.map((trip) => (
              <TableRow key={trip.id}>
                <TableCell>{trip.id}</TableCell>
                <TableCell>{trip.direction}</TableCell>
                <TableCell>{trip.distance}</TableCell>
                <TableCell>{trip.duration}</TableCell>
                <TableCell>{trip.passengerCount}</TableCell>
              </TableRow>
            ))}
          </TableBody>
        </Table>
      </TableContainer>
    </Card>
  );
}
