'use client';

import * as React from 'react';
import { Box, Grid, Typography, Stack, Button } from '@mui/material';
import { LocalizationProvider } from '@mui/x-date-pickers';
import { AdapterDateFns } from '@mui/x-date-pickers/AdapterDateFns';
import { RoadMapStyledTimePicker, StyledTextField } from '@/shared/theme/css';
import { Dayjs } from 'dayjs';
import FontAwesome from '@/shared/components/fontawesome';
import { faClock, faNoteSticky } from '@fortawesome/free-solid-svg-icons';
import { pxToRem } from '@/shared/theme/typography';

export default function VisitSection() {
  const [garageStart, setGarageStart] = React.useState<Date | Dayjs | null>(null);
  const [garageEnd, setGarageEnd] = React.useState<Date | null>(null);
  const [medicalStart, setMedicalStart] = React.useState<Date | null>(null);
  const [medicalEnd, setMedicalEnd] = React.useState<Date | null>(null);

  return (
    <LocalizationProvider dateAdapter={AdapterDateFns}>
      <Typography
        variant="h5"
        sx={{
          color: 'primary.main',
          fontSize: pxToRem(22),
          fontWeight: (theme) => theme.typography.fontWeightBold,
          m: 3,
        }}
      >
        Autres trajets
      </Typography>
      <Box
        sx={{
          backgroundColor: 'white',
          borderRadius: 2,
          p: 3,
          boxShadow: 1,
        }}
      >
        <Grid container spacing={4}>
          {/* TimePickers */}
          <Grid item xs={6}>
            <Typography variant="h6">Visite garage</Typography>
            <Box mt={1}>
              <Stack direction="row" spacing={2}>
                <RoadMapStyledTimePicker
                  label="Début visite garage"
                  slots={{
                    openPickerIcon: () => (
                      <FontAwesome icon={faClock} sx={{ color: 'primary.main' }} />
                    ),
                  }}
                  views={['hours', 'minutes']}
                  format="HH:mm"
                />
                <RoadMapStyledTimePicker
                  label="Fin visite garage"
                  slots={{
                    openPickerIcon: () => (
                      <FontAwesome icon={faClock} sx={{ color: 'primary.main' }} />
                    ),
                  }}
                  views={['hours', 'minutes']}
                  format="HH:mm"
                />
              </Stack>
            </Box>
          </Grid>

          <Grid item xs={6}>
            <Typography variant="h6">Visite médicale</Typography>
            <Box mt={1}>
              <Stack direction="row" spacing={2}>
                <RoadMapStyledTimePicker
                  label="Début visite médicale"
                  slots={{
                    openPickerIcon: () => (
                      <FontAwesome icon={faClock} sx={{ color: 'primary.main' }} />
                    ),
                  }}
                  views={['hours', 'minutes']}
                  format="HH:mm"
                />
                <RoadMapStyledTimePicker
                  label="Fin visite médicale"
                  slots={{
                    openPickerIcon: () => (
                      <FontAwesome icon={faClock} sx={{ color: 'primary.main' }} />
                    ),
                  }}
                  views={['hours', 'minutes']}
                  format="HH:mm"
                />
              </Stack>
            </Box>
          </Grid>
        </Grid>
      </Box>
      <Typography
        variant="h5"
        sx={{
          color: 'primary.main',
          fontSize: pxToRem(22),
          fontWeight: (theme) => theme.typography.fontWeightBold,
          m: 3,
        }}
      >
        Observation
      </Typography>
      <Box
        sx={{
          backgroundColor: 'white',
          borderRadius: 2,
          p: 3,
          boxShadow: 1,
          mb: 5,
        }}
      >
        <StyledTextField
          fullWidth
          multiline
          label="Observations"
          placeholder="Saisissez vos observations"
          InputLabelProps={{
            shrink: true,
          }}
          InputProps={{
            endAdornment: <FontAwesome icon={faNoteSticky} sx={{ color: 'primary.main' }} />,
          }}
        />
      </Box>
      <Box
        sx={{
          display: 'flex',
          justifyContent: 'flex-end',
          gap: 2,
          alignItems: 'center',
          mb: 5,
        }}
      >
        <Stack direction="row" spacing={2} justifyContent="flex-end">
          <Button variant="outlined" color="primary">
            Annuler
          </Button>
          <Button variant="contained" color="primary">
            Soumettre
          </Button>
        </Stack>
      </Box>
    </LocalizationProvider>
  );
}
