'use client';

import React, { useEffect, useMemo, useState } from 'react';
import TableManager from '@/shared/components/table/table-manager';
import SubmittedRoaMapTableRow from './submitted-roadmap-table-row';
import { ISubmittedRoadmap } from '@/shared/types/driver';
import { SubmittedRoadMapDTO, SubmittedRoadMapFilterParams } from '@/shared/types/roadMap';
import { SelectChangeEvent } from '@mui/material';
import { useRoadMapStore } from '@/shared/api/stores/roadMapStore';
interface SubmittedRoadMapTableProps {
  table: any;
  filteredData: SubmittedRoadMapDTO[];
  filters: any;
  tableHead: any[];
  notFound: boolean;
  dataToExport: any;
  activeTab: string;
  onFilterChange: (key: string, value: string, condition: string) => void;
  onResetFilters: () => void;
  onResetColumns: () => void;
  onColumnsChange: (columns: any[]) => void;
  handleEdit: (row: SubmittedRoadMapDTO) => void;
  handleCopy: (row: SubmittedRoadMapDTO) => void;
  handleView: (row: SubmittedRoadMapDTO) => void;
  handleOldRoadMapsClick: (roadmap: SubmittedRoadMapDTO) => void;
  handleContact: (row: SubmittedRoadMapDTO) => void;
}


export default function SubmittedRoadMapTable({
  table,
  filteredData,
  filters,
  tableHead,
  notFound,
  dataToExport,
  activeTab,
  onFilterChange,
  onResetFilters,
  onResetColumns,
  onColumnsChange,
  handleEdit,
  handleCopy,
  handleView,
  handleOldRoadMapsClick,
  handleContact,
}: SubmittedRoadMapTableProps) {

  const {
  submittedRoadMaps,
  getAllSubmittedRoadMaps,
  loading,
  error,
  totalElements
} = useRoadMapStore();

  const [selectedRow, setSelectedRow] = useState<any | null>(null);

  const renderRow = (row: SubmittedRoadMapDTO) => (
    <SubmittedRoaMapTableRow
      key={row.id}
      dense={table.dense}
      row={row}
      handleCopy={handleCopy}
      handleEdit={handleEdit}
      handleDetails={handleView}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead.slice(0, -2)}
      onClickOldRoadMaps={handleOldRoadMapsClick}
      onClickContact={handleContact}
    />
  );

  return (
    <>
      <TableManager
        filteredData={filteredData}
        table={table}
        tableHead={tableHead}
        notFound={notFound}
        filters={filters}
        onFilterChange={onFilterChange}
        renderRow={renderRow}
        loading={loading}  
        count={totalElements}
      />
    </>
  );
}
