"use client"

import ScheduleVerificationTable from "@/shared/components/roadmap/schedule-verification-table"
import {
  _driverScheduleList,
  _geolocationList,
  DEFAULT_DRIVER_SCHEDULE_TABLE_HEAD,
  DEFAULT_GEOLOCATION_TABLE_HEAD,
} from "@/shared/_mock/_roadMap"
import WeeklyVerificationPanel, { VerificationTableType } from "@/shared/components/roadmap/weekly-verification-panel"

export default function TripCombinedTable() {
  return (
    <WeeklyVerificationPanel
      title="Verification du planning des  trajets effectues et ses donnees de feuille de route soumise"
      tableConfigs={[
        {
          title: "Planning théorique des trajets effectuées",
          columns: DEFAULT_GEOLOCATION_TABLE_HEAD,
          data: _geolocationList,
          verificationType: VerificationTableType.geolocation,
          component: ScheduleVerificationTable,
        },
        {
          title: "Feuille de route soumise",
          columns: DEFAULT_GEOLOCATION_TABLE_HEAD,
          data: _geolocationList,
          verificationType: VerificationTableType.geolocation,
          component: ScheduleVerificationTable,
        },
      ]}
    />
  )
}

