import { Box } from "@mui/material";
import DriverRoadMapDetails from "../components/validate-roadmap/driver-roadmap-details";
import FormContainer from "@/layouts/form/form-container";
import DriverCombinedTable from "../components/validate-roadmap/combined-table-driver";
import TripCombinedTable from "../components/validate-roadmap/combined-table-trip";
import ValidationCombinedTable from "../components/validate-roadmap/combined-table-validation";
import FinalResultTable from "../components/validate-roadmap/FinalResultTable";

export default function ValidateRoadmapView() {
  return (
    <FormContainer sx={{backgroundColor: 'transparent',p:0}} hasBorder >
      <DriverRoadMapDetails />
      <Box sx={{ display: 'flex', flexDirection: 'column', gap: 2, mt: 2 }}>
        <DriverCombinedTable  />
        <TripCombinedTable  />
        <ValidationCombinedTable  />
        <FinalResultTable showButton={true} />
      </Box>
    </FormContainer>
  );
}
