"use client"
import ScheduleTable from "@/shared/components/form/schedule-table"
import SvgColor from "@/shared/components/svg-color"
import {
  Dialog,
  DialogTitle,
  DialogContent,
  Divider,
  List,
  ListItem,
  ListItemIcon,
  ListItemText,
  IconButton,
} from "@mui/material"
import FontAwesome from "@/shared/components/fontawesome"
import { faClose } from '@fortawesome/free-solid-svg-icons';

type UsagerDetailsDialogProps = {
  open: boolean
  onClose: () => void
  usager: string | null
}

export default function UsagerDetailsDialog({ open, onClose, usager }: UsagerDetailsDialogProps) {
  if (!usager) return null

  return (
    <Dialog open={open} onClose={onClose} maxWidth="xl" fullWidth>
      <DialogTitle sx={{ color: "primary.main", m: 0, p: 2 }}>
        {usager}
        <IconButton
          aria-label="close"
          onClick={onClose}
          sx={{
            position: "absolute",
            right: 8,
            top: 10,
            color: (theme) => theme.palette.grey[500],
          }}
        >
          <FontAwesome icon={faClose} width={18}/>
        </IconButton>
      </DialogTitle>
      <DialogContent dividers>
        <List dense sx={{ p: 0 }}>
          <ListItem sx={{ p: 0 }}>
            <ListItemIcon sx={{ minWidth: "auto", mr: 2 }}>
              <SvgColor
                src="/assets/icons/menu/ic_exploitation.svg"
                sx={{ color: "primary.main", width: 18, height: 18 }}
              />{" "}
            </ListItemIcon>
            <ListItemText primary={"Particularité du transport"} secondary={"Transport par minibus"} sx={{ m: 0 }} />
          </ListItem>
        </List>

        <Divider sx={{ my: 2 }} />
        <ScheduleTable title="Emploi du temps" mode="time" isRepresentative />
      </DialogContent>
    </Dialog>
  )
}
