import { ICircuit } from '@/shared/types/circuit';
import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { INITIAL_CIRCUIT_DATA } from '../../../_mock/_circuit';

const circuitConfig: TabConfig<ICircuit> = {
  type: 'circuit',
  listTitle: 'Liste des circuits',
  newItemTitle: 'Nouveau circuit',
  initialData: INITIAL_CIRCUIT_DATA,
  getItemCode: (circuit) => circuit.codeCircuit,
};

export function useCircuitTabs() {
  return useTabsManager<ICircuit>(circuitConfig);
}

