import * as Yup from 'yup';

export const circuitContractSchema = Yup.object().shape({
  contrat: Yup.string().required('Le contrat est requis'),
  numeroLot: Yup.array().of(Yup.string()).min(1, 'Au moins un numéro de lot est requis'),
}); 

export const circuitSchema = Yup.object().shape({
  etat: Yup.string().required('L\'état du circuit est requis'),
  codeCircuit: Yup.string().required('code circuit est requis'),
  intitule: Yup.string().required('Intitule du circuit est requis'),
  etablissement: Yup.string().required('L\'établissement principal est requis'),
  adresseEtablissement: Yup.object().shape({
      address: Yup.string().required('L\'adresse est requise'),
      lat: Yup.number(),
      lng: Yup.number(),
    }),
  typeCalcul: Yup.string().required('Le type de calcul est requis'),
  grillePrix: Yup.string().nullable(),
  dateDebut: Yup.string().required('La date de début est requise'),
  dateFin: Yup.string().required('La date de fin est requise'),
  colorCode: Yup.string().required('Le code couleur est requis'),
  chauffeur: Yup.string().nullable(),
  observation: Yup.string().nullable(),
});

export const chauffeurSchema = Yup.object().shape({
  trajet: Yup.string().required('Le trajet est requis'),
  chauffeur: Yup.string().required('Le nom du chauffeur est requis'),
  dateDebut: Yup.string().required('La date de début est requise'),
  dateFin: Yup.string().nullable(),
  joursAttribues: Yup.array().of(Yup.string()).required('Les jours attribués sont requis'),
  observation: Yup.string().nullable(),
}); 