// hooks/use-attendance-tabs.ts
import { AttendanceSheet, AttendanceSheetStatus } from '@/shared/types/attendance-sheet';
import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { TableType } from '@/shared/types/common';
import { AttendanceUnion } from '../utils/attendance-utils';

export interface TabContentBase {
  id: string;
  data: AttendanceSheet;
  currentStep: "form" | "sheet";
  attendance: AttendanceUnion;
}

const initialValues: TabContentBase = {
  id: '',
  data: {
    id: '',
    number: '',
    year: 0,
    month: '',
    departmentId: 0,
    departmentName: "",
    circuitId: '',
    circuitName: null,
    status: AttendanceSheetStatus.ACTIVE,
    presenceDaysCount: 0,
    absenceDaysCount: 0,
    schoolDaysCount: 0,
    transportArCount: 0,
    createdAt: '',
    updatedAt: '',
    isActive: true,
  },
  currentStep: "form",
  attendance: {},
};

const attendanceTabsConfig: TabConfig<TabContentBase> = {
  type: TableType.AttendanceSheet,
  listTitle: 'Historique feuille de présence',
  newItemTitle: 'Nouvelle feuille de présence',
  initialData: initialValues,
  getItemCode: (attendance) => attendance.data.number,
};

export function useAttendanceTabs() {
  return useTabsManager<TabContentBase>(attendanceTabsConfig);
}

export type AttendanceTabContent = TabContentBase;