import { circuitOptions } from "@/shared/_mock/_circuit";
import { AttendanceSheet, AttendanceSheetList } from "@/shared/types/attendance-sheet";
import { FormFieldType } from "@/shared/types/common"
import { Departements, IAttendanceSheet, Months } from "@/shared/types/etablissement"

export const YEARS = Array.from({ length: 5 }, (_, i) => ({
  label: `${new Date().getFullYear() - i}`,
  value: `${new Date().getFullYear() - i}`,
}))

export const DEPARTEMENT_OPTIONS = Object.values(Departements).map((departement) => ({
  label: departement,
  value: departement,
}));

export const MONTH_OPTIONS = Object.values(Months).map((month,index) => ({
  label: month,
  value: (index+1).toString(),
}));


export const vacationFormFields: FormFieldType<IAttendanceSheet>[] = [
  {
    name: "circuitName",
    label: "Circuit",
    type: "combobox",
    options: circuitOptions,
  },
  {
    name: "departmentName",
    label: "Departement",
    type: "select",
    options: DEPARTEMENT_OPTIONS,
    required:true
  },
  {
    name: "month",
    label: "Mois",
    type: "select",
    options:MONTH_OPTIONS,
    required:true
  },
  {
    name: "year",
    label: "Année",
    type: "select",
    options: YEARS,
    required:true
  },
  ]