"use client"

import { type TableConfig, useTableManager } from "@/hooks/use-table-manager"
import type { IFuelFee } from "@/shared/types/flottes/fuelFee"
import { _fuelFees, DEFAULT_FUEL_FEE_TABLE_HEAD } from "@/shared/_mock/flottes/_fuelFees"

const fuelFeeConfig: TableConfig<IFuelFee> = {
  initialData: _fuelFees,
  defaultTableHead: DEFAULT_FUEL_FEE_TABLE_HEAD,
}

export function useFuelFeeTable() {
  return useTableManager<IFuelFee>(fuelFeeConfig)
}
