import { _petrolier } from "@/shared/_mock"
import { _FUEL_TYPE_OPTIONS } from "@/shared/_mock/flottes/_fuelFees"
import type { FormFieldType } from "@/shared/types/common"
import type { IFuelHistory, ITankerType } from "@/shared/types/flottes/fuelImport"
import { faNoteSticky, faTachometerAlt, faTags } from "@fortawesome/free-solid-svg-icons"

export const supplierTypeFormFields: FormFieldType<ITankerType>[] = [
  {
    name: "typeTanker",
    label: "Pétrolier",
    type: "select",
    required: true,
    options: _petrolier.map((P) => ({ label: P, value: P })),
    placeholder: "Choisissez un pétrolier",
  },
  {
    name: "type",
    label: "Type Carburant",
    type: "select",
    options: _FUEL_TYPE_OPTIONS,
    placeholder: "Choisissez un type de carburant",
  },
  {
    name: "observation",
    label: "Observation",
    type: "textarea",
    icon: faNoteSticky
  },
]

export const fuelHistoryFormFields: FormFieldType<IFuelHistory>[] = [
  {
    name: "providerType",
    label: "Pétrolier",
    type: "text",
    required: true,
    icon: faTags
  },
  {
    name: "registrationDate",
    label: "Date d'enregistrement",
    type: "date",
  },
  {
    name: "kilometer",
    label: "Kilométrage",
    type: "text",
    icon: faTachometerAlt
  }
]