import type React from 'react';
import { Grid, Typography, Box } from '@mui/material';
import { TableType, type FormFieldType, type ModeType, type TableColumn } from '@/shared/types/common';
import ActionButtons from '@/shared/components/form/buttons-action';
import EditExportButtons from '@/shared/components/form/edit-export-buttons';
import {
  mainIncidentFormFields,
  descriptionIncidentFormFields,
} from '../utils/form-fields-incident';
import type { IIncident } from '@/shared/types/flottes/incident';

interface InterventionTabProps {
  renderField: (field: FormFieldType<IIncident>) => React.ReactNode;
  mode: ModeType;
  onSave: () => void;
  onClose: () => void;
  onEdit: () => void;
  tableHead: TableColumn[]
  incident?:IIncident
}

export default function SinistreDetails({
  mode,
  onSave,
  onClose,
  onEdit,
  renderField,
  incident,
  tableHead
}: InterventionTabProps) {
  const isReadOnly = mode === 'view';

  return (
    <>
      {isReadOnly ? (
        <EditExportButtons onEdit={onEdit} onExport={() => void 0}           
        tooltipTitle={TableType.Incident}
        dataRow={incident}
        tableHead={tableHead} />
      ) : (
        <></>
      )}
      <form>
        <Grid container spacing={5}>
          {mainIncidentFormFields.map((field) => (
            <Grid item xs={12} sm={4} key={field.name}>
              {renderField(field)}
            </Grid>
          ))}
        </Grid>

        <Typography
          variant="h6"
          sx={{
            color: 'primary.main',
            my:3,
            fontWeight: 'bold',
          }}
        >
          Description du sinistre
        </Typography>
        <Grid container spacing={5}>
          {descriptionIncidentFormFields.map((field) => (
            <Grid item xs={12} sm={4} key={field.name}>
              {renderField(field)}
            </Grid>
          ))}

          {!isReadOnly ? (
            <Grid item xs={12}>
              <ActionButtons onSave={onSave} onCancel={onClose} mode={mode} />
            </Grid>
          ) : (
            <></>
          )}
        </Grid>
      </form>
    </>
  );
}
