import { TableConfig, useTableManager } from '@/hooks/use-table-manager';
import { IVehicle } from '@/shared/types/flottes/vehicule';
import { _vehicles, DEFAULT_VEHICLE_TABLE_HEAD } from '@/shared/_mock/flottes/_vehicle';

const vehicleConfig: TableConfig<IVehicle> = {
  initialData: _vehicles,
  defaultTableHead: DEFAULT_VEHICLE_TABLE_HEAD,
};

export function useVehicleTable() {
  return useTableManager<IVehicle>(vehicleConfig);
}