"use client"
import Checkbox from "@mui/material/Checkbox"
import TableCell from "@mui/material/TableCell"
import Switch from "@mui/material/Switch"

import TableActionColumn from "@/shared/components/table/table-action-column"
import SvgColor from "@/shared/components/svg-color"

import type { TableColumn } from "@/shared/types/common"
import { ContratStyledRow, getStatusColor } from "@/shared/sections/contract/styles"
import { ITypeIncident } from "@/shared/types/flottes/incident"
import ConditionalComponent from "@/shared/components/table/ConditionalComponent"

type Props = {
  handleEditIncidentType: (incidentType: ITypeIncident) => void
  handleDetailsIncidentType: (incidentType: ITypeIncident) => void
  selected: boolean
  row: ITypeIncident
  onSelectRow: VoidFunction
  columns: TableColumn[]
}

const TOOLTIP_TITLES = {
  edit: "Modifier type d'incident",
  duplicate: "Copier type d'incident",
  active: "Type d'incident actif",
  inactive: "Type d'incident inactif",
}

export default function IncidentTypeTableRow({
  row,
  handleEditIncidentType,
  handleDetailsIncidentType,
  selected,
  onSelectRow,
  columns,
}: Props) {
  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      default:
        return value
    }
  }

  return (
    <ContratStyledRow hover style={{ cursor: "pointer" }}>

      {columns.filter((c)=>c.id!=='isActive').map((column: any, index: number) => (
        <TableCell
          onDoubleClick={() => handleDetailsIncidentType(row)}
          key={column.id}
          align={column.align}
          sx={{ whiteSpace: "nowrap", py: column.id === "isActive" ? 0 : "inherit", ...(index === 0 && {position: "relative"}), }}
        >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
              src="/assets/icons/ic_border.svg"
              sx={{ position: "absolute", top: 0, left: -4, height: "100%", color: getStatusColor(row.intitule) }}
            />
            </ConditionalComponent>
          {renderCellContent(column.id, row[column.id as keyof ITypeIncident])}
        </TableCell>
      ))}

      <TableCell align="right" sx={{ px: 1, whiteSpace: "nowrap" }}>
        <TableActionColumn
          handleEdit={() => handleEditIncidentType(row)}
          onToggle={(checked) => void 0}
          isActive={row.isActive}
          tooltipTitles={TOOLTIP_TITLES}
        />
      </TableCell>
    </ContratStyledRow>
  )
}
