import { type TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"
import { INITIAL_VEHICLE_MODEL_DATA } from "@/shared/_mock/flottes/_vehicle"
import { IVehicleModel } from "@/shared/types/flottes/vehicule"

const vehicleModelConfig: TabConfig<IVehicleModel> = {
  type: "modèle de véhicule",
  listTitle: "Liste des marques / modèles",
  newItemTitle: "Nouveau modèle",
  initialData: INITIAL_VEHICLE_MODEL_DATA,
  getItemCode: (vehicleModel) => `${vehicleModel.marque} ${vehicleModel.modele}`,
}

export function useVehicleModelTabs() {
  return useTabsManager<IVehicleModel>(vehicleModelConfig)
}
