'use client';

import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import TableActionColumn from '@/shared/components/table/table-action-column';
import SvgColor from '@/shared/components/svg-color';
import type { TableColumn } from '@/shared/types/common';
import type { ISupplierType } from '@/shared/types/flottes/vehicule';
import { ContratStyledRow, getStatusColor } from '@/shared/sections/contract/styles';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

type Props = {
  handleEditSupplierType: (supplierType: ISupplierType) => void;
  handleDetailsSupplierType: (supplierType: ISupplierType) => void;
  selected: boolean;
  row: ISupplierType;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
};

const TOOLTIP_TITLES = {
  edit: "Modifier type de fournisseur",
  duplicate: "Copier type de fournisseur",
  active: "Type de fournisseur actif",
  inactive: "Type de fournisseur inactif",
};

export default function SupplierTypeTableRow({
  row,
  handleEditSupplierType,
  handleDetailsSupplierType,
  selected,
  onSelectRow,
  columns,
}: Props) {
  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      default:
        return value;
    }
  };

  return (
    <ContratStyledRow hover style={{ cursor: 'pointer' }}>
      {columns.filter((c) => c.id !== 'isActive').map((column: any, index: number) => (
        <TableCell
          onDoubleClick={() => handleDetailsSupplierType(row)}
          key={column.id}
          align={column.align}
          sx={{ whiteSpace: 'nowrap', py: column.id === 'isActive' ? 0 : 'inherit', ...(index === 0 && {position: "relative"}), }}
        >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
              src="/assets/icons/ic_border.svg"
              sx={{ position: "absolute", top: 0, left: -4, height: "100%", color: getStatusColor(row.intitule) }}
            />
            </ConditionalComponent>
          {renderCellContent(column.id, row[column.id as keyof ISupplierType])}
        </TableCell>
      ))}

      <TableCell align="right" sx={{ px: 1, whiteSpace: 'nowrap' }}>
        <TableActionColumn
          handleEdit={() => handleEditSupplierType(row)}
          onToggle={(checked) => void 0}
          isActive={row.isActive}
          tooltipTitles={TOOLTIP_TITLES}
        />
      </TableCell>
    </ContratStyledRow>
  );
} 