'use client';

import type React from 'react';
import { useState, type ReactNode } from 'react';
import { IconButton, Stack, Box, Slider, Typography, Button } from '@mui/material';
import FontAwesome from '@/shared/components/fontawesome';
import { WhiteIconButtonStyle } from '@/shared/theme/css';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import SvgColor from '@/shared/components/svg-color';
import {
  faCircleChevronLeft,
  faCircleChevronRight,
  faPrint,
  faRotate,
  faPlus
} from '@fortawesome/free-solid-svg-icons';
import { alpha, styled } from '@mui/system';
import { lightColor, mainButtonStyle } from '@/shared/components/table/styles';
import TableFilter from '@/shared/components/table/table-filter';
import { TableType, TimeUnit } from '@/shared/types/common';
import { DatePickerPopover } from '@/shared/components/schedule/date-picker-popover';
import { Dayjs } from 'dayjs';

const CustomSlider = styled(Slider)(({ theme }) => ({
  color: '#8B7FFF',
  height: 4,
  '& .MuiSlider-thumb': {
    height: 16,
    width: 16,
    backgroundColor: '#fff',
    border: '6px solid #8B7FFF',
    boxShadow: `0 0 0 3px white`,
  },
  '& .MuiSlider-track': {
    height: 1,
    borderRadius: 2,
  },
  '& .MuiSlider-rail': {
    height: 3,
    borderRadius: 2,
    backgroundColor: alpha(theme.palette.primary.main, 0.2),
  },
}));

export const ExtendedWhiteIconButtonStyle = {
  ...WhiteIconButtonStyle,
  padding: 0.9,
};

interface ScheduleToolbarProps {
  date: Date;
  onDateChange: (date: Dayjs | Date, timeUnit?: TimeUnit) => void;
  onZoomChange: (zoom: number) => void;
  onFilters: (key: string, value: string, condition: string) => void;
  onResetFilters: () => void;
  initialColumns: { id: string; label: string; type?: string }[];
  type: TableType;
  customAction?: ReactNode;
  timeUnit?: TimeUnit;
  goToPreviousMonth?: () => void;
  goToNextMonth?: () => void;
  isChild?: boolean;
  onCreateEvent?: () => void;
}

export function ScheduleToolbar({
  date,
  onDateChange,
  onZoomChange,
  onFilters,
  onResetFilters,
  initialColumns,
  type,
  customAction,
  timeUnit = 'day',
  goToPreviousMonth,
  goToNextMonth,
  isChild = false,
  onCreateEvent,
}: ScheduleToolbarProps) {
  const [calendarAnchor, setCalendarAnchor] = useState<null | HTMLElement>(null);
  const [zoomValue, setZoomValue] = useState<number>(50);

  const handleCalendarClick = (event: React.MouseEvent<HTMLButtonElement>) => {
    setCalendarAnchor(event.currentTarget);
  };

  return (
    <Box sx={{ 
      display: 'flex', 
      justifyContent: 'center', 
      pb: 1,
      position: 'relative',
      width: '100%'
    }}>
      <Stack direction="row" spacing={1} alignItems="center">
        {customAction ? customAction : <></>}
        <CustomTooltip title="Calendrier" arrow>
          <IconButton
            sx={isChild ? lightColor : ExtendedWhiteIconButtonStyle}
            onClick={handleCalendarClick}
          >
            <SvgColor
              src="/assets/icons/ic_date.svg"
              sx={{
                width: 18,
                height: 18,
              }}
            />
          </IconButton>
        </CustomTooltip>

        <TableFilter
          onResetFilters={onResetFilters}
          onFilters={onFilters}
          initialColumns={initialColumns}
          type={type}
          isChild={isChild}
        />
      </Stack>

      {onCreateEvent && (
        <Button
          variant="contained"
          size="small"
          onClick={onCreateEvent}
          startIcon={<FontAwesome icon={faPlus} width={16} />}
          sx={{
            position: 'absolute',
            right: 24,
            top: 0,
            bgcolor: 'primary.main',
            color: 'white',
            '&:hover': {
              bgcolor: 'primary.dark',
            },
            borderRadius: '8px',
            textTransform: 'none',
            height: '32px'
          }}
        >
          Ajouter
        </Button>
      )}
    </Box>
  );
} 