import { TableRow, TableCell, Typography, Box } from '@mui/material';
import { VehicleInfo } from './vehicle-info';
import { TimeSlotCell } from './time-slot-cell';
import { getHourIntervals, getMinuteIntervals } from '../utils/planning-utils';
import { Vehicle, ScheduleData, TimeSlot } from '../types/planning-types';
interface VehicleRowProps {
  vehicle: Vehicle;
  scheduleData: ScheduleData;
  cellWidth: number;
  selectedDate: Date;
  onTimeSlotDoubleClick: (slot: TimeSlot) => void;
  onPopoverOpen: (event: React.MouseEvent<HTMLElement>, vehicle: Vehicle) => void;
  onPopoverOpenT: (event: React.MouseEvent<HTMLElement>, slot: TimeSlot) => void;
  onPopoverClose: () => void;
  onPopoverCloseT: () => void;
}
export const VehicleRow = ({
  vehicle,
  scheduleData,
  selectedDate,
  cellWidth,
  onTimeSlotDoubleClick,
  onPopoverOpen,
  onPopoverClose,
  onPopoverOpenT,      
  onPopoverCloseT,
}:VehicleRowProps) => (
  <TableRow hover>
    <TableCell
      sx={{
        position: 'sticky',
        left: 0,
        backgroundColor: 'background.paper',
        zIndex: 2,
      }}
      onMouseEnter={(e) => onPopoverOpen(e, vehicle)}
      onMouseLeave={onPopoverClose}
    >
      <VehicleInfo vehicle={vehicle} />
    </TableCell>
    {/* Time slots */}
    {getHourIntervals(selectedDate).map((hour) =>
      getMinuteIntervals().map((minute) => (
        <TimeSlotCell
          key={`${hour.hour}:${minute}`}
          vehicle={vehicle}
          hour={hour}
          minute={minute}
          scheduleData={scheduleData}
          cellWidth={cellWidth}
          onTimeSlotDoubleClick={onTimeSlotDoubleClick}
          onPopoverOpenT={onPopoverOpenT}       // Add this
          onPopoverCloseT={onPopoverCloseT} 
        />
      ))
    )}
  </TableRow>
); 