import { FormFieldType } from '@/shared/types/common';
import {
  faHashtag,
  faUserTie,
  faStickyNote,
  faFileAlt,
  faCalendarAlt,
  faCheckCircle,
  faUserCheck,
  faBuilding,
  faExchangeAlt,
  faClipboardCheck,
  faIdBadge
} from '@fortawesome/free-solid-svg-icons';
import { IRHAbsence } from '../../../../types/absence-rh';
import { _CHAUFFEURS, _MODES_RECEPTION, _TYPES_ABSENCE, _DEPARTEMENTS } from '@/shared/_mock/_rhAbsence';
import { DRIVERS } from '@/shared/_mock/_appointment';
import { _BINARY_Qst } from '@/shared/_mock/_trajets';
import { DriverAbsenceStatus } from '@/shared/types/driver-absence';
import { _OPTION_DRIVER_ABSENCE } from '@/shared/_mock/_absenceDriver';

export type OptionType = {
  value: string;
  label: string;
};

export const createFormFieldsRHAbsence = (): FormFieldType<IRHAbsence>[] => [
  {
    name: 'nomChauffeur',
    label: 'Nom',
    type: 'select',
    required: true,
    options: _CHAUFFEURS.map(chauffeur => ({ value: chauffeur, label: chauffeur })),
    icon: faUserTie
  },
  {
    name: 'type',
    label: 'Type',
    type: 'select',
    required: true,
    options: [
      { value: 'chauffeur', label: 'Chauffeur' },
      { value: 'sédentaire', label: 'Sédentaire' }
    ],
    icon: faIdBadge
  },
  {
    name: 'typeAbsence',
    label: 'Type d\'absence',
    type: 'select',
    required: true,
    options: _TYPES_ABSENCE.map(type => ({ value: type, label: type })),
    icon: faClipboardCheck
  },
  {
    name: 'dateDebut',
    label: 'Date de début',
    type: 'date',
    required: true,
    icon: faCalendarAlt
  },
  {
    name: 'dateFin',
    label: 'Date de fin',
    type: 'date',
    required: true,
    icon: faCalendarAlt
  },
  {
    name: 'modeReception',
    label: 'Mode de réception',
    type: 'select',
    options: _MODES_RECEPTION.map(mode => ({ value: mode, label: mode })),
    icon: faExchangeAlt
  },
  {
    name: 'justificatif',
    label: 'Justificatif',
    placeholder: 'Entrez le type de justificatif',
    type: 'text',
    icon: faFileAlt
  },
  {
    name: 'affecteTrajet',
    label: 'Affecte un trajet',
    type: "checkbox",
    options: _BINARY_Qst,
  },
  {
    name: 'statut',
    label: 'Statut',
    type: 'select',
    options: _OPTION_DRIVER_ABSENCE,
  },
  {
    name: 'nbrHeures',
    label: 'Nbr des heures',
    type: 'number',
    required: true,
    icon: faHashtag
  },
  {
    name: "autorisePar",
    label: "Autorisé Par",
    type: "select",
    options: DRIVERS
  },
  {
    name: "validerPar",
    label: "Validé Par",
    type: "select",
    options: DRIVERS
  },
  {
    name: 'departement',
    label: 'Département',
    type: 'text',
    required: true,
    icon: faBuilding
  }
];