import { Box, Typography, Stack, Chip, IconButton, Drawer } from '@mui/material';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faArrowLeft, faArrowRight } from '@fortawesome/free-solid-svg-icons';
import { formatDate } from '@/utils/format-time';

interface DocumentHistoryProps {
  open: boolean;
  onClose: () => void;
}

export default function DocumentHistory({ open, onClose }: DocumentHistoryProps) {
  // This would normally come from your backend
  const historyItems = [
    {
      id: 1,
      date: new Date('2024-03-15'),
      action: 'Document généré',
      document: 'Contrat de travail - John Doe',
      status: 'Généré'
    },
    {
      id: 2,
      date: new Date('2024-03-14'),
      action: 'Document envoyé',
      document: 'Attestation - Jane Smith',
      status: 'Envoyé'
    },
    // Add more history items as needed
  ];

  return (
    <Drawer
      anchor="right"
      open={open}
      onClose={onClose}
      variant="persistent"
      sx={{
        '& .MuiDrawer-paper': {
          width: 400,
          boxSizing: 'border-box',
          borderLeft: '1px solid',
          borderColor: 'divider',
        },
      }}
    >
      <Box sx={{ p: 2, borderBottom: '1px solid', borderColor: 'divider' }}>
        <Box sx={{ display: 'flex', alignItems: 'center', gap: 2 }}>
          <IconButton
            onClick={onClose}
            sx={{
              width: 28,
              height: 28,
              borderRadius: '8px',
              backgroundColor: 'primary.lighter',
              color: 'primary.main',
              '&:hover': {
                backgroundColor: 'primary.light',
              },
            }}
          >
            <FontAwesomeIcon icon={faArrowLeft} width={16} />          </IconButton>
          <Typography variant="h6" sx={{ fontSize: '1rem', fontWeight: 600 }}>
            Historique des demandes
          </Typography>
        </Box>
      </Box>

      <Box sx={{ p: 3 }}>
        <Typography variant="body2" color="text.secondary" sx={{ mb: 3 }}>
          Suivi et consultation des documents précédemment générés
        </Typography>

        <Stack spacing={2}>
          {historyItems.map((item) => (
            <Box
              key={item.id}
              sx={{
                p: 2,
                border: '1px solid',
                borderColor: 'divider',
                borderRadius: 1,
                backgroundColor: 'background.paper',
              }}
            >
              <Stack direction="row" alignItems="center" justifyContent="space-between">
                <Box>
                  <Typography variant="subtitle2">
                    {item.action}
                  </Typography>
                  <Typography variant="body2" color="text.secondary">
                    {item.document}
                  </Typography>
                  <Typography variant="caption" color="text.disabled">
                    {formatDate(item.date)}
                  </Typography>
                </Box>
                <Chip
                  label={item.status}
                  size="small"
                  color="primary"
                  variant="outlined"
                />
              </Stack>
            </Box>
          ))}
        </Stack>
      </Box>
    </Drawer>
  );
} 