import { Box, Typography, LinearProgress, Stack } from "@mui/material"

interface StorageUsageProps {
  usedSpace: number
  totalSpace: number
}

export default function StorageUsage({ usedSpace, totalSpace }: StorageUsageProps) {
  const usagePercentage = (usedSpace / totalSpace) * 100

  return (
    <Stack direction="column" justifyContent="flex-end" alignItems="center" sx={{ width: '100%' }}>
      <Stack direction="row" justifyContent="center" alignItems="center" spacing={1} sx={{ marginBottom: 1 }}>
        <Box sx={{ typography: 'body', mt: 0.5, fontWeight: 'bold', fontSize: '1.3rem' }}>{usedSpace} MO</Box>
        <Box sx={{ typography: 'body2', color: 'text.disabled', mt: 0.5 }}>
          utilisé(s) sur {totalSpace} MO
        </Box>
      </Stack>
      <LinearProgress
        variant="determinate"
        value={usagePercentage}
        color="primary"
        sx={{
          width: '100%',
          height: 8,
          '@media (min-width: 1200px)': {
            width: '30%',
          },
        }}
      />
    </Stack>
  )
}

