'use client';

import React from 'react';
import { Box, Typography, Button, Paper, useTheme } from '@mui/material';
import ComputerIcon from '@mui/icons-material/Computer';

interface DesktopNotificationBannerProps {
  onActivate: () => void;
  onIgnore: () => void;
}

const DesktopNotificationBanner = ({ onActivate, onIgnore }: DesktopNotificationBannerProps) => {
  const theme = useTheme();
  
  return (
    <Paper sx={{ p: 3, mb: 4, bgcolor: '#f8f9fb', borderRadius: 3}}>
      <Box sx={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
        <Box sx={{ display: 'flex', alignItems: 'center' }}>
          <ComputerIcon sx={{ mr: 2, color: theme.palette.primary.main }} />
          <Box>
            <Typography variant="h6" sx={{ fontWeight: 500 }}>
              Notifications de bureau
            </Typography>
            <Typography variant="body2" color="text.secondary">
              Recevoir des notifications directement sur mon Windows
            </Typography>
          </Box>
        </Box>
        <Box>
          <Button 
            variant="text" 
            sx={{ mr: 2, color: 'text.secondary' }}
            onClick={onIgnore}
          >
            Ignorer
          </Button>
          <Button 
            variant="contained" 
            color="primary"
            onClick={onActivate}
          >
            Activer les notifications sur le bureau
          </Button>
        </Box>
      </Box>
    </Paper>
  );
};

export default DesktopNotificationBanner;