import { etablissementsOptions } from '@/shared/_mock/_avenantUsager';
import { FormFieldType } from '@/shared/types/common';
import { IAvenantUsager } from '@/shared/types/usager';
import {
    faStickyNote,
    faListUl,
    faKeyboard,
  } from '@fortawesome/free-solid-svg-icons'
  export const usagerAvenantFormFields1: FormFieldType<IAvenantUsager>[] = [
    {
      name: 'dateApplication',
      label: 'Début de transport',
      type: 'date',
    },
    {
      name: 'avenantTemporaire',
      label: 'Au / Avenant temporaire/Stage',
      type: 'date',
    },
    {
      name: 'objetAvenant',
      label: 'Objet de l\'avenant',
      placeholder: 'Entrez l\'objet',
      type: 'text',
      icon: faKeyboard,
    },
    {
      name: 'etablissement',
      label: 'Etablissement',
      placeholder: 'Choisissez un nom',
      type: 'select',
      options: etablissementsOptions,
    },
  ]

  
  export const usagerAvenantFormFields2: FormFieldType<IAvenantUsager>[] = [
    {
      name: 'specificite',
      label: 'Spécificité',
      placeholder: 'Entrez un texte',
      type: 'text',
      icon: faListUl,
    },
    {
      name: 'observation',
      label: 'Observation',
      placeholder: 'Ajoutez une note ou une observation',
      type: 'textarea',
      icon: faStickyNote,
    },
  ]
  