import { _BINARY_Qst } from '@/shared/_mock/_trajets';
import { FormFieldType } from '@/shared/types/common';
import {  Representative, RelationType, Interlocutor, PassengerContact } from '@/shared/types/passenger';
import {  Civility } from '@/shared/types/common';
import { faEnvelope, faMobileScreenButton, faPhone, faPhoneFlip, faStickyNote, faStopwatch, faUserTie, faVoicemail } from '@fortawesome/free-solid-svg-icons';
import { _CIVILITE } from './form-fields-usager';
import { IRepresentative } from '@/shared/types/usager';

  export const _CIVILITE_OPTIONS = [
    { value: Civility.MR, label: "M." },
    { value: Civility.MME, label: "Mme." },
    { value: Civility.M_MME, label: "M.Mme." },
    { value: Civility.MM, label: "MM." },
    { value: Civility.MMS, label: "Mmes." },
    { value: Civility.OTHER, label: "Autre" },
  ];
  export const _REPRESENTANT_TYPE = [
    { value: RelationType.MOTHER, label: 'Mère' },
    { value: RelationType.FATHER, label: 'Père' },
    { value: RelationType.GRANDPARENT, label: 'Grands-parents' },
    { value: RelationType.GROUP_HOME, label: 'Foyer de vie' },
    { value: RelationType.MEDICAL_FACILITY, label: 'Établissement médico-social' },
    { value: RelationType.OTHER, label: 'Autre' },
  ];
  export const _Boolean_Options = [
    { value: "true", label: "Oui" },
    { value: "false", label: "Non" },
  ];

export const mainRepresentantformFields: FormFieldType<Representative>[] = [
  {
    name: 'type',
    label: 'Type',
    type: 'select',
    options: _REPRESENTANT_TYPE,
  },
  {
    name: 'civility',
    label: 'Civilité',
    type: 'checkbox',
    options: _CIVILITE_OPTIONS,
  },
  {
    name: 'firstName',
    label: 'Nom parent',
    placeholder: 'Entrez un Nom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'lastName',
    label: 'Prénom Parent',
    placeholder: 'Entrez un Prénom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'addresses',
    label: 'Address',
    type: 'address',
    required: true,
  },
];

export const contactsFormFields: FormFieldType<PassengerContact>[] = [
  {
    name: 'mobilePhones',
    label: 'Tel mobile',
    placeholder: 'Entrez un tel mobile',
    type: 'text',
    icon: faMobileScreenButton,
  },
  {
    name: 'landlinePhones',
    label: 'Tel Fixe',
    placeholder: 'Entrez une tel fixe',
    type: 'text',
    icon: faPhoneFlip,
  },
  {
    name: 'assignedPersons',
    label: 'Personne',
    placeholder: 'Entrez un text',
    type: 'text',
    icon: faUserTie,
  },
]
export const contactFormFields: FormFieldType<Representative>[] = [

  {
    name: 'email',
    label: 'E-mail',
    placeholder: 'Entrez un e-mail',
    type: 'text',
    required: true,
    icon: faEnvelope,
  },
  {
    name: 'circuitCode',
    label: 'Circuit',
    placeholder: 'Entrez un text',
    type: 'text',
    icon: '/assets/icons/menu/ic_exploitation.svg',
  },
  {
    name: 'addresses',
    label: 'Prise en charge',
    type: 'address',
    required: true,
  },
  {
    name: 'parentalAuthorization',
    label: 'Auto. parentale',
    type: 'checkbox',
    options: _Boolean_Options,
  },
  {
    name: 'arrivalNotification',
    label: "Notification d'arivee",
    type: 'checkbox',    
    options: _Boolean_Options,
  },
];

export const interlocuteursFormFields: FormFieldType<Interlocutor>[] = [
  {
    name: 'civility',
    label: 'Civilité',
    type: 'checkbox',
    options: _CIVILITE,
  },
  {
    name: 'firstName',
    label: 'Nom',
    placeholder: 'Entrez un nom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'lastName',
    label: 'Prénom',
    placeholder: 'Entrez un prénom',
    type: 'text',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'mobilePhone',
    label: 'Tel mobile',
    placeholder: 'Entrez un tel',
    type: 'text',
    icon: faMobileScreenButton,
  },
  {
    name: 'email',
    label: 'E-mail',
    placeholder: 'Entrez un e-mail',
    type: 'text',
    icon: faEnvelope,
  },
  {
    name: 'type',
    label: 'Type',
    placeholder: 'Choisissez une valeur',
    type: 'select',
    options: _REPRESENTANT_TYPE,
  },
  {
    name: 'observations',
    label: 'Observation',
    placeholder: 'Ajoutez une note ou une observation',
    type: 'textarea',
    icon: faStickyNote,
  },
];
