import { type Representative, DaysOfWeek, SensTrip, WeekType, type TransportSchedule, type DaySchedule } from "@/shared/types/passenger"

export const convertSchedulesToSelectedDays = (transportSchedules: Representative["transportSchedules"]) => {
    const selectedDays: any = {
        pair: {},
        impair: {},
    }

    transportSchedules.forEach((schedule) => {
        const weekKey = schedule.weekType === WeekType.EVEN ? "pair" : "impair"

        schedule.daySchedules.forEach((daySchedule) => {
            const day = daySchedule.dayOfWeek.toLowerCase()
            if (!selectedDays[weekKey][day]) {
                selectedDays[weekKey][day] = { all: false, ret: false }
            }

            if (daySchedule.sens === SensTrip.DEPARTURE) {
                selectedDays[weekKey][day].all = true
            } else if (daySchedule.sens === SensTrip.RETURN) {
                selectedDays[weekKey][day].ret = true
            }
        })
    })

    return selectedDays
}

export const convertSelectedDaysToSchedules = (selectedDays: any): TransportSchedule[] => {

    const transportSchedules: TransportSchedule[] = [
        {
            id: "",
            weekType: WeekType.EVEN,
            daySchedules: [] as DaySchedule[],
        },
        {
            id: "",
            weekType: WeekType.ODD,
            daySchedules: [] as DaySchedule[],
        },
    ]

    const dayMap: Record<string, DaysOfWeek> = {
        monday: DaysOfWeek.MONDAY,
        tuesday: DaysOfWeek.TUESDAY,
        wednesday: DaysOfWeek.WEDNESDAY,
        thursday: DaysOfWeek.THURSDAY,
        friday: DaysOfWeek.FRIDAY,
        saturday: DaysOfWeek.SATURDAY,
        sunday: DaysOfWeek.SUNDAY,
    }

    Object.entries(selectedDays.pair || {}).forEach(([day, value]: [string, any]) => {
        if (dayMap[day]) {
            if (value.all) {
                transportSchedules[0].daySchedules.push({
                    id: "",
                    dayOfWeek: dayMap[day],
                    sens: SensTrip.DEPARTURE,
                    checked: true,
                })
            }
            if (value.ret) {
                transportSchedules[0].daySchedules.push({
                    id: "",
                    dayOfWeek: dayMap[day],
                    sens: SensTrip.RETURN,
                    checked: true,
                })
            }
        }
    })

    Object.entries(selectedDays.impair || {}).forEach(([day, value]: [string, any]) => {
        if (dayMap[day]) {
            if (value.all) {
                transportSchedules[1].daySchedules.push({
                    id: "",
                    dayOfWeek: dayMap[day],
                    sens: SensTrip.DEPARTURE,
                    checked: true,
                })
            }
            if (value.ret) {
                transportSchedules[1].daySchedules.push({
                    id: "",
                    dayOfWeek: dayMap[day],
                    sens: SensTrip.RETURN,
                    checked: true,
                })
            }
        }
    })

    return transportSchedules
} 