import { AddressData, Civility } from "./common";

export interface IBaseEntity {
  id: string;
  createdAt?: string;
  updatedAt?: string;
}
export interface IRole extends IBaseEntity {
  name: string;
  description: string;
}
export interface IUser extends IBaseEntity {
  lastName: string;
  firstName: string;
  email: string;
  personalEmail?: string;
  birthDate?: string;
  birthPlace?: string;
  civility?: Civility;       
  phoneNumber: string;
  password:string;
  userStatus?: UserStatus;     
  photoUrl?: string;
  isArchived: boolean;
  addresses?: AddressDTO[];
  roles: IRole[];  
}

export interface IClient extends IUser {
  clientName?: string;
  landlinePhone?: string;
  mainBranch?: MainBranch;
  agencyName?:string;
  portalAssignment?: PortalAssignment;  
  signatureDate?: string;
  colorCode?: string;
  siret?: string;
  tva?: string;
  agency_id?: number;
  ape_code?: number;
  paymentDate?: string;
  observation?: string;
  bankName?: string;
  iban?: string;
  auxiliaryAccount?: string;
  salesAccount?: string;
  accountingAccount?: string;
  accountHolder?: string;
  accountAddress?: string;
  swiftBic?: string;
  clientType?: ClientTypeDTO;
  mapAdresse?:AddressData;
}
export interface MapAddresse {
  address: string,
  lat: number,
  lng: number,
  city: string,
  postalCode: string,
  country: string,
  formattedAddress: string
}

export interface AddressDTO  extends IBaseEntity {

  latitude: number;
  longitude: number;
  street: string;
  city: string;
  country: string;
  zipCode: string;
  additionalAddress?: string;
  addressType: AddressType;  

}

  export interface ClientTypeDTO  extends IBaseEntity{
    name: string;
  }

  export enum AddressType {
    COLLABORATOR = 'COLLABORATOR',
    CLIENT = 'CLIENT',
    ESTABLISHMENT = 'ESTABLISHMENT',
    REPRESENTATIVE = 'REPRESENTATIVE',
    BANQUE = 'BANQUE',
    DRIVER = 'DRIVER'
  }

  export enum MainBranch {
    TAD = 'TAD',
    CLIENT = 'CLIENT'
  }

  export enum PortalAssignment {
    TAD = 'TAD',
    CLIENT = 'CLIENT'
  }

  export enum UserStatus {
    INACTIF = 'INACTIF',
    ACTIF = 'ACTIF',
    DELETED = 'DELETED'
  }

  export interface Pageable<T> {
    content: T[];
    totalElements: number;
    totalPages: number;
    size: number;
    number: number;
    first: boolean;
    last: boolean;
    empty: boolean;
    sort: {
      empty: boolean;
      sorted: boolean;
      unsorted: boolean;
    };
    offset: number;
    pageNumber: number;
    pageSize: number;
    paged: boolean;
    unpaged: boolean;
    numberOfElements: number;
  }
  
  
  export type IClientPageable = Pageable<IClient>;
  export interface ClientPageFilterParams {
    page?: number;
    size?: number;
    sortBy?: string;
    sortDirection?: 'asc' | 'desc';
  }
  