import { AddressType, IBaseEntity, IUser } from './client';
import { Address } from './establishment';
import { Civility } from './common';

export enum RoleStatus {
  ENABLED = 'ENABLED',
  DISABLED = 'DISABLED'
}

export enum CustodyCategory {
  ALTERNATING_CUSTODY = 'ALTERNATING_CUSTODY',
  RETURNS_AT_NOON = 'RETURNS_AT_NOON'
}

export enum ParticularityTransport {
  AUTISME = 'AUTISME',
  DEFICIENT_VISUEL = 'DEFICIENT_VISUEL',
  FAUTEUIL_ELECTRIQUE = 'FAUTEUIL_ELECTRIQUE',
  FAUTEUIL_ELECTRIQUE_103 = 'FAUTEUIL_ELECTRIQUE_103',
  FAUTEUIL_MANUEL = 'FAUTEUIL_MANUEL',
  FAUTEUIL_MANUEL_TRANSFERABLE = 'FAUTEUIL_MANUEL_TRANSFERABLE',
  FAUTEUIL_PLIANT = 'FAUTEUIL_PLIANT',
  GILLES_DE_LA_TOURETTE = 'GILLES_DE_LA_TOURETTE',
  MALVOYANT = 'MALVOYANT',
  MARCHANT = 'MARCHANT',
  MOBILITE_REDUITE = 'MOBILITE_REDUITE',
  NON_TRANSFERABLE = 'NON_TRANSFERABLE',
  PERSONNE_AGEE = 'PERSONNE_AGEE',
  TRANSFERABLE = 'TRANSFERABLE',
  TRANSPORT_INDIVIDUALISE = 'TRANSPORT_INDIVIDUALISE',
  TRISOMIE_21 = 'TRISOMIE_21'
}

export enum State {
  CONTROLLED = 'CONTROLLED',
  UNCONTROLLED = 'UNCONTROLLED'
}
export const _PassengerStatus = [
  { value: State.CONTROLLED, label: "Contrôlé" },
  { value: State.UNCONTROLLED, label: "Non Contrôlé" },
];

export enum SchoolClass {
  SECONDE = 'SECONDE',
  TERMINALE = 'TERMINALE',
  CE1 = 'CE1',
  CE2 = 'CE2',
  CM1 = 'CM1',
  CM2 = 'CM2'
}

export enum RelationType {
  MOTHER = 'MOTHER',
  FATHER = 'FATHER',
  GRANDPARENT = 'GRANDPARENT',
  GROUP_HOME = 'GROUP_HOME',
  MEDICAL_FACILITY = 'MEDICAL_FACILITY',
  OTHER = 'OTHER'
}

export enum PassengerCivility  {
  MR = 'MR',
  MME = 'MME',
}

export interface PassengerContact extends IBaseEntity {
  landlinePhones: string[];
  mobilePhones: string[];
  assignedPersons: string[];
}

export interface AddressDTO extends IBaseEntity {
  latitude: number;
  longitude: number;
  street: string;
  city: string;
  country: string;
  zipCode: string;
  additionalAddress: string;
  addressType: AddressType;
}

export interface PassengerRepresentative extends IBaseEntity {
  firstName: string;
  lastName: string;
  email?: string;
  civility: Civility;
  type:RelationType;
}

export interface Representative extends PassengerRepresentative {
  parentalAuthorization: boolean;
  arrivalNotification: boolean;
  idCircuit: string;
  circuitCode: string;
  contacts: PassengerContact[];
  addresses: Address[];
  transportSchedules: TransportSchedule[];
}

export interface Interlocutor extends PassengerRepresentative {
  mobilePhone: string;
  observations: string;
}

export interface IRole extends IBaseEntity {
  name: string;
  description: string;
  status: RoleStatus;
  permissions: string[];
}

export interface IUserPassenger extends Omit<IUser, 'addresses' | 'password' | 'roles' | 'civility' | 'isArchived'> {
  roles: IRole[];
  civility?: PassengerCivility;
}

export interface IPassengerList extends IUserPassenger {
  openingDays: string;
  observations: string;
  startTransport: string;
  specificity: string;
  referentTeacherName: string;
  custodyCategory: CustodyCategory;
  particularityTransport: ParticularityTransport;
  state: State;
  idEstablishment: number;
  establishmentName: string;
  idDepartment: number;
  departmentName: string;
  age: number;
  schoolClass: SchoolClass;
  representatives: Representative[];
  interlocutor: Interlocutor | null;
  archived: boolean;
}

export interface SearchPassengerParams {
  id?: number;
  lastName?: string;
  firstName?: string;
  birthDate?: string;
  birthPlace?: string;
  schoolClass?: string;
  startTransport?: string;
  observations?: string;
  departmentName?: string;
  type?: string;
  representativeFirstName?: string;
  representativeLastName?: string;
  representativeEmail?: string;
  landlinePhones?: string;
  mobilePhones?: string;
  address?: string;
  circuitCode?: string;
  establishmentName?: string;
  page?: number;
  size?: number;
  sortBy?: string;
  sortDir?: 'ASC' | 'DESC';
}

export interface TransportSchedule extends IBaseEntity {
  weekType: WeekType;
  daySchedules: DaySchedule[];
}
export interface DaySchedule extends IBaseEntity {
  dayOfWeek: DaysOfWeek;
  sens: SensTrip;
  checked: boolean;
}
export enum WeekType {
  EVEN = 'EVEN',
  ODD = 'ODD'
}
export enum DaysOfWeek {
  MONDAY = 'MONDAY',
  TUESDAY = 'TUESDAY',
  WEDNESDAY = 'WEDNESDAY',
  THURSDAY = 'THURSDAY',
  FRIDAY = 'FRIDAY',
  SATURDAY = 'SATURDAY',
  SUNDAY = 'SUNDAY'
}
export enum SensTrip {
  DEPARTURE = 'DEPARTURE',
  RETURN = 'RETURN'
}