import IconButton from '@mui/material/IconButton';
import SvgColor from '@/shared/components/svg-color';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import { WhiteIconButtonStyle } from '@/shared/theme/css';
import { useRouter } from 'next/navigation';

// ----------------------------------------------------------------------

export default function PlaningPopover() {
  const router = useRouter();

  const handlePlanningClick = () => {
    router.push('/dashboard/exploitation/chauffeur/planning');
  };

  return (
    <CustomTooltip title="Planning Chauffeur" arrow>
      <IconButton sx={WhiteIconButtonStyle} onClick={handlePlanningClick}>
        <SvgColor
          src="/assets/icons/navbar/ic_table.svg"
          sx={{ width: { xs: 20, lg: 22 }, height: { xs: 20, lg: 22 } }}
        />
      </IconButton>
    </CustomTooltip>
  );
}

