import React, { useState } from 'react';
import Stack from '@mui/material/Stack';
import AppBar from '@mui/material/AppBar';
import Toolbar from '@mui/material/Toolbar';
import { useTheme } from '@mui/material/styles';

import { useOffSetTop } from '@/hooks';
import { useResponsive } from '@/hooks';

import AccountPopover from '../common/account-popover';
import NotificationPopover from '../common/notification-popover';
import ChatPopover from '../common/chat-popover';
import DrivePopover from '../common/drive-popover';
import PositionPopover from '../common/position-popover';
import MenuPopover from '../common/menu-popover';
import PlaningPopover from '../common/planning-popover';
import { NAV, HEADER } from '../config-layout';
import { useNavBar } from '@/contexts/settings/nav-bar-context';
import Searchbar from '../common/searchbar';
import PlaningLocation from '../common/planing-location';
import ExportNavigation from '../common/export-navigation';

type Props = {
  onOpenNav?: VoidFunction;
};

export default function Header() {
  const theme = useTheme();
  const offset = useOffSetTop(HEADER.H_DESKTOP);
  const { isNavBarMinimized, toggleNavBar } = useNavBar();
  const lgUp = useResponsive('up', 'lg');

  const renderContent = (
    <>
      <MenuPopover />

      <Stack  
        flexGrow={1}
        direction="row"
        alignItems="center"
        justifyContent="flex-end"
        spacing={{ xs: 0.5, sm: 1 }}
      >
       
        <ExportNavigation />
        <Searchbar />
        <PlaningLocation/>
        <PlaningPopover />
        <PositionPopover />
        <DrivePopover />
        <ChatPopover />
        <NotificationPopover />
        <AccountPopover />
      </Stack>
    </>
  );
  return (
    <>
      <AppBar
        sx={{
          height: HEADER.H_MOBILE,
          zIndex: theme.zIndex.appBar + 1,
          bgcolor: 'transparent',
          boxShadow: 'none',
          border: 'none', 
          transition: theme.transitions.create(['height'], {
            duration: theme.transitions.duration.shorter,
          }),
          width: `calc(100% - ${NAV.W_VERTICAL + 1}px)`,
          ...(lgUp && {height: HEADER.H_DESKTOP}),
          ...(offset && {
            height: HEADER.H_DESKTOP_OFFSET,
          }),
          ...(isNavBarMinimized && {
            width: `calc(100% - ${NAV.W_MINI + 1}px)`,
          }),
        }}
      >
        <Toolbar
          sx={{
            height: 1,
            pl: { lg: 3 },
            pr: { lg: 2 },
          }}
        >
          {renderContent}
        </Toolbar>
      </AppBar>
    </>
  );
}
