import { IPreparationDriver } from "../types/driver";
import { AddressData, TableColumn } from "../types/common";
import { _CHAUFFEURS } from "./_absenceDriver";
import { _noms, _prenoms, ADRESSE, MOCK_ADDRESSES } from ".";



export const _driversPreparation = [...Array(55)].map((_, index) => {
  const startDate = new Date(2002 + Math.floor(index / 12), index % 12, 15);
  const driverCode = `DRV-2024-${String.fromCharCode(65 + (index % 26))}${String.fromCharCode(65 + (Math.floor(index / 26)))}`;
  const mockAddress = MOCK_ADDRESSES[index % 4];
  
  return {
    id: (index + 1).toString(),
    nom: _noms[index % 4],
    prenom: _prenoms[index % 4],
    adresse: mockAddress,
    ville: mockAddress.city || ['Paris', 'Lyon', 'Marseille', 'Bordeaux'][index % 4],
    codePostal: mockAddress.postalCode || `${(10000 + (index * 1000)) % 99000}`,
    nomCircuit: `Ligne ${['Nord', 'Sud', 'Est', 'Ouest'][index % 4]}`,
    codeChauffeur: driverCode,
    dateDepart: startDate.toISOString().split('T')[0],
    etat: ['true', 'false'][index % 2],
    observation: index % 3 === 0 ? 'Observation importante' : '',
  };
});


export const DEFAULT_DRIVER_PREPARATION_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'N°', type: 'text', align: 'center' },
  { id: 'nom', label: 'Nom', type: 'text', align: 'left' },
  { id: 'prenom', label: 'Prénom', type: 'text', align: 'left' },
  { id: 'adresse', label: 'Adresse', type: 'text', align: 'left' },
  { id: 'codePostal', label: 'Code postal', type: 'text', align: 'center' },
  { id: 'ville', label: 'Ville', type: 'text', align: 'left' },
  { id: 'nomCircuit', label: 'Circuit', type: 'text', align: 'left' },
  { id: '', label: 'Action' },
];

export const INITIAL_DRIVER_PREPARATION_DATA: IPreparationDriver = {
  id: '',
  nom: '',
  prenom: '',
  adresse: {
    address: '',
    lat: 0,
    lng: 0,
    city: '',
    postalCode: '',
    country: '',
    formattedAddress: ''
  },
  ville: '',
  codePostal: '',
  nomCircuit: '',
  disponibilite: '',
  codeChauffeur: '',
  dateDepart: '',
  etat: '',
  observation: '',
};