import { IGeolocData, IMileage } from "@/shared/types/flottes/mileage";
import { _noms, _petrolier, _prenoms, generateDateRange, generatePhoneNumber, getDepartement, IMMATRICULATIONS } from "..";
import { TableColumn } from "@/shared/types/common";


  export const _mileageList = [...Array(20)].map((_, index) => {
    const { startDate, endDate } = generateDateRange(index)
  
    return {
      id: (index + 1).toString(),
      firstname: _prenoms[index % 4],
      lastname: _noms[index % 4],
      car: IMMATRICULATIONS[index % IMMATRICULATIONS.length],
      petrolier: _petrolier[index % _petrolier.length],
      telephone: generatePhoneNumber("+33"),
      anormalKm: (index + 1).toString(),
      startDate: startDate,
      endDate: endDate,
      department: getDepartement(index),
      circuit: `Circuit ${index + 1}`,
    }
  })
  

export const INITIAL_MILEAGE_DATA: IMileage = {
    id: "",
    lastname: "",
    firstname: "",
    car: "",
    petrolier: "",
    telephone: "",
    anormalKm: "",
    endDate:"",
    department:"",
    startDate:""
  };

export const MILEAGE_TABLE_HEAD: TableColumn[] = [
  { id: 'firstname', label: 'Prenom' , type: 'text'},
  { id: 'lastname', label: 'Nom' , type: 'text'},
  { id: 'car', label: 'Véhicule', type: 'text' },
  { id: 'petrolier', label: 'Pétrolier', type: 'text' },
  { id: 'telephone', label: 'Téléphone', type: 'text' },
  { id: 'anormalKm', label: 'kilométrage anormale', type: 'text', width:150 },
  { id: 'startDate', label: 'Date début', type: 'date' },
  { id: 'endDate', label: 'Date Fin', type: 'date' },
  { id: 'department', label: 'Département', type: 'text' },
];

export const mockedGeolocData: IGeolocData = {
  id: 1,
  departureDate: '2024-04-03T08:30:00Z',
  arrivalDate: '2024-04-03T10:15:00Z',
  departureLat: 34.0522,
  departureLong: -118.2437,
  arrivalLat: 36.7783,
  arrivalLong: -119.4179,
  carRegistration: 'AB-123-CD',
  departureLocation: 'Los Angeles, CA',
  arrivalLocation: 'Fresno, CA',
  dateImported: '2024-04-03T11:00:00Z',
  isNormal: true,
  isSendMail: false,
  causes: 'Écart de kilométrage détecté',
  observation: 'Trajet conforme aux prévisions',
  errors: '',
  justification: null,
  managed: true,
  correctData: true,
  begin: 1712142600,
  end: 1712150100,
  duration: 6300,
  distance: 350.5,
  route: 'Highway 99',
};
