const endpointPrefix = "/api/admin"

export const contractEndpoints = {
  getContractsPage: endpointPrefix + "/contracts/page",
  getContractById: (id: string) => endpointPrefix + `/contracts/${id}`,
  createContract: endpointPrefix + "/contracts",
  toogleActivation: (id: string, active: boolean) => endpointPrefix + `/contracts/toggle-activation/${id}?active=${active}`,
  updateContract: (id: string) => endpointPrefix + `/contracts/update/${id}`,
  startExportFiltredContracts: endpointPrefix + "/contracts/start-filtered-export",
  updateContractStatus: (id: string) => endpointPrefix + `/contracts/update-status/${id}`,
};