import { create } from 'zustand';

import axiosInstance from '@/utils/axios';
import { userEndpoints } from '../endpoints/user';
import { IAgent } from '@/shared/types/client';

type AgentStore = {
  agents: IAgent[];
  loading: boolean;
  error: string | null;
  getAllAgents: () => Promise<void>;
};

export const useAgentStore = create<AgentStore>((set) => ({
  agents: [],
  loading: false,
  error: null,

  getAllAgents: async () => {
    set({ loading: true, error: null });
    try {
      const response = await axiosInstance.get(userEndpoints.user.getAllUsers);
      set({ agents: response.data, loading: false });
    } catch (error: any) {
      set({
        error: error.message || 'Failed to fetch agents',
        loading: false,
      });
    }
  },
}));