import type React from "react"
import { Stack, IconButton } from "@mui/material"
import { faPenToSquare, faFileExport } from "@fortawesome/free-solid-svg-icons"
import CustomTooltip from "@/shared/components/tooltips/tooltip-custom"
import FontAwesome from "@/shared/components/fontawesome"
import { iconButtonStyles } from "@/shared/theme/css"
import { TableColumn } from "@/shared/types/common"
import ExportButton from '@/shared/components/table/table-export-button';

interface EditExportButtonsProps {
  onEdit?: () => void
  onExport?: () => void
  tooltipTitle?: string
  dataRow?: any
  tableHead?: TableColumn[];
}

const 
EditExportButtons: React.FC<EditExportButtonsProps> = ({
  onEdit,
  onExport,
  tooltipTitle = '',
  dataRow = [],
  tableHead = []
}) => {
  return (
    <Stack flexGrow={0} direction="row" alignItems="center" justifyContent="flex-end" gap="8px" pb={1}>
      {onEdit ? (
        <CustomTooltip title={`Modifier ${tooltipTitle}`} arrow>
          <IconButton onClick={onEdit} size="small" sx={iconButtonStyles}>
            <FontAwesome icon={faPenToSquare} width={16} />
          </IconButton>
        </CustomTooltip>
      ) : <></>}
      {onExport ? (
        <ExportButton
        tooltipTitle={`Exporter ${tooltipTitle}`}
        type={tooltipTitle}
        filteredData={[dataRow]}
        tableHead={tableHead}
      />
      ) : <></>}
    </Stack>
  )
}

export default EditExportButtons

