import { IconDefinition } from "@fortawesome/free-solid-svg-icons";

export interface SubColumn {
  id: string;
  label: string;
  align?: 'left' | 'center' | 'right';
}

export interface CustomColumn {
  id: string;
  label: string;
  colSpan?: number;
  subColumns?: SubColumn[];
}

interface RowData {
  id: number | string;
  [key: string]: any;
}

export interface RoadMapValidationTableProps {
  columns: CustomColumn[];
  data: RowData[];
  maxHeight?: string;
  isFinalResult?: boolean;
}

export interface IconButtonProps {
  isExpanded: boolean
  icon: IconDefinition
  onClick?: (e: React.MouseEvent) => void
  position?: "top" | "bottom"
}