import { _CHAUFFEURS } from "@/shared/_mock/_absenceDriver";
import { _CIRCUIT_STATUS } from "@/shared/_mock/_circuit";
import { _BINARY_Qst } from "@/shared/_mock/_trajets";
import { IPreparationCircuit } from "@/shared/types/circuit";
import { FormFieldType } from "@/shared/types/common";

const _USAGERS = _CHAUFFEURS.map(driver => ({ 
  value: driver, 
  label: driver 
}));

export const preparationCircuitFormFields: FormFieldType<IPreparationCircuit>[] = [
  {
    name: 'etat',
    label: 'État du circuit',
    type: 'select',
    options: _CIRCUIT_STATUS,
  },
  {
    name: 'etablissement',
    label: 'Établissement principal',
    type: 'text',
    placeholder: 'Entrez un nom',
    required: true,
    icon: '/assets/icons/form/ic_building.svg',
  },
  {
    name: 'kmAVide',
    label: 'Km à vide',
    type: 'text',
    placeholder: '0',
    icon:'/assets/icons/menu/ic_exploitation.svg',
  },
  {
    name: 'adresseEtablissement',
    label: 'Prise en charge',
    type: 'address',
    placeholder: 'Entrez une adresse',
  },
  {
    name: 'typeCalcul',
    label: 'Type de calcul',
    type: 'select',
    options: [
      { value: 'calculCouts', label: 'Calcul pour les Coûts' },
      { value: 'calculAutres', label: 'Autres calculs' },
    ],
  },
  {
    name: 'colorCode',
    label: 'Code couleur',
    type: 'color',
    placeholder: 'Choisissez une couleur',
    required: true,
    icon: '/assets/icons/form/ic_palette.svg',
  },

  {
    name: 'dateDebut',
    label: 'Date de début',
    type: 'date',
    required: true,
  },
  {
    name: 'dateFin',
    label: 'Date de fin',
    type: 'date',
    required: true,
  },
  {
    name: 'toll',
    label: 'Péage',
    type: 'select',
    options: _BINARY_Qst
  },
  {
    name: 'usagers',
    label: 'usagers',
    type: 'multiple',
    options: _USAGERS
  },
  {
    name: 'observation',
    label: 'Observation',
    type: 'textarea',
    placeholder: 'Ajoutez une note ou une observation',
  }
];