import * as yup from 'yup';

export const preparationCircuitSchema = yup.object().shape({
    etablissement: yup.string().required('Ce champ est obligatoire'),
    colorCode: yup.string().required('Une couleur est requise'),
    dateDebut: yup.date().required('Date requise'),
    adresseEtablissement: yup.object().shape({
      address: yup.string().required('L\'adresse est requise'),
      lat: yup.number(),
      lng: yup.number(),
    }),
    dateFin: yup.date()
      .required('Date requise')
      .min(yup.ref('dateDebut'), 'La date de fin doit être après la date de début'),
    kmAVide: yup.number().min(0, 'Doit être positif').required('Ce champ est obligatoire'),
    toll: yup.string().required('Sélection requise'),
    usagers: yup.array().min(1, 'Au moins un usager requis'),
  });