  import { FormFieldType } from '@/shared/types/common';
  import { _AGENT_STATUS } from '@/shared/_mock/_agent';
  import { _teams } from '@/shared/_mock/_equipes';
  import { faBuilding, faBuildingUser, faCalendar, faClock, faEnvelope, faFileContract, faHistory, faHome, faIdCard, faListCheck, faLocationDot, faLock, faPhone, faSignature, faSitemap, faUser, faUserShield, faUsers } from '@fortawesome/free-solid-svg-icons';
  import { CollaboratorStatus, ContractType, IAgent, IRole } from '@/shared/types/client';

  export const CONTRACT_TYPES = [
    { value: 'CDI', label: 'CDI' },
    { value: 'CDD', label: 'CDD' },
    { value: 'Intérim', label: 'Intérim' },
  ];

  export const AGENT_ROLES = [
    { value: 'aucun', label: 'Aucun' },
    { value: 'admin', label: 'Admin' },
    { value: 'manager', label: 'Manager' },
    { value: 'agent', label: 'Agent' },
    { value: 'auditeur', label: 'Auditeur' },
    { value: 'superviseur', label: 'Superviseur' },
  ];

  export const PERMISSIONS = [
    { value: 'read', label: 'Lire' },
    { value: 'write', label: 'Ecrire' },
    { value: 'edit', label: 'Modifier' },
    { value: 'delete', label: 'Supprimer' },
  ];

  export const TEAMS_OPTIONS = _teams.map(team => ({
    value: team.id,
    label: `${team.name} (${team.id})`
  }));

  export const personalInfoFields: FormFieldType<IAgent>[] = [
    { name: 'lastName', label: 'Nom', type: 'text', required: true, icon: faSignature },
    { name: 'firstName', label: 'Prénom', type: 'text', required: true, icon: faUser },
    { name: 'birthDate', label: 'Date de naissance', type: 'date', required: true, icon: faCalendar },
    { name: 'birthPlace', label: 'Lieu de naissance', type: 'text', required: true, icon: faLocationDot },
    { name: 'mapAdresse', label: 'Adresse', type: 'address', required: true, icon: faPhone }, // addresses correspond à AddressDTO[]
    { name: 'phoneNumber', label: 'Téléphone', type: 'text', required: true, icon: faPhone },
    { name: 'personalEmail', label: 'E-mail', type: 'text', icon: faEnvelope },
  ];

  export const professionalInfoFields = (
    AgencyNames: { label: string; value: string }[],
    DepartmentNames: { label: string; value: string }[],
    TeamNames: { label: string; value: string }[]
  ): FormFieldType<IAgent>[] => [
    { name: 'agentIdentifier', label: 'Identifiant Agent', type: 'text', required: true, icon: faBuildingUser },
    { name: 'agencyName', label: 'Agence', type: 'select', required: true, options: AgencyNames, icon: faBuilding },
    { name: 'email', label: 'E-mail professionnel', type: 'text', required: true, icon: faEnvelope },
    { name: 'password', label: 'Mot de passe', type: 'text', required: true, icon:faLock},
    { name: 'socialSecurityNumber', label: 'Numéro de sécurité sociale', type: 'text', required: true, icon: faIdCard },
    { name: 'departmentName', label: 'Département', type: 'select',  options: DepartmentNames, required: true, icon: faSitemap },
    { name: 'teams', label: 'Équipe', type: 'multiple', options: TeamNames, required: false, icon: faUsers },
    { name: 'contractType', label: 'Type de contrat', type: 'select',
      options: Object.keys(ContractType).map(key => ({
        value: ContractType[key as keyof typeof ContractType],
        label: ContractType[key as keyof typeof ContractType],
      })),
      required: true, icon: faFileContract },
    { name: 'collaboratorStatus', label: 'Statut', type: 'select', options: Object.keys(CollaboratorStatus).map(key => ({
        value: CollaboratorStatus[key as keyof typeof CollaboratorStatus],
        label: CollaboratorStatus[key as keyof typeof CollaboratorStatus],
      })),
      required: true },
  ];

 export const rolePermissionFields = (
  RoleNames: { label: string; value: string }[],
): FormFieldType<any>[] => [
  {
    name: 'roles',
    label: 'Rôle assigné',
    type: 'select',
    options: RoleNames,
    required: true,
    icon: faUserShield,
  },
  {
    name: 'permissions',
    label: 'Permissions',
    type: 'text',
    required: true,
    icon: faListCheck,
  },
];