import { FormFieldType } from "@/shared/types/common"
import { INotification, NotificationChannel, NotificationType, NotificationCategory, DeliveryType } from "@/shared/types/notification"
import { 
  faBell,
  faEnvelope,
  faMessage,
  faTag,
  faCalendar,
  faClock,
  faPaperclip,
  faCheckCircle,
} from "@fortawesome/free-solid-svg-icons"

// Mock recipients for dropdown
export const RECIPIENTS_OPTIONS = [
  { value: "all_users", label: "Tous les utilisateurs" },
  { value: "all_employees", label: "Tous les employés" },
  { value: "dev_team", label: "Équipe Développement" },
  { value: "marketing_team", label: "Équipe Marketing" },
  { value: "hr_users", label: "Utilisateurs du département RH" },
  { value: "jean_dupont", label: "Jean Dupont" },
  { value: "marie_martin", label: "Marie Martin" },
  { value: "sophie_bernard", label: "Sophie Bernard" },
  { value: "pierre_durand", label: "Pierre Durand" },
]

export const notificationFormFields: FormFieldType<INotification>[] = [
  {
    name: 'title',
    label: 'Titre de la Notification',
    type: 'text',
    placeholder: 'Entrez le titre de la notification',
    icon: faTag,
    required: true,
  },

  {
    name: 'type',
    label: 'Type de notification',
    type: 'select',
    options: Object.values(NotificationType).map(type => ({ value: type, label: type })),
    placeholder: 'Sélectionnez un type',
    icon: faBell,
    required: true,
  },
  {
    name: 'category',
    label: 'Catégorie',
    type: 'select',
    options: Object.values(NotificationCategory).map(category => ({ value: category, label: category })),
    placeholder: 'Sélectionnez une catégorie',
    required: true,
  },
  {
    name: 'recipients',
    label: 'Destinataires',
    type: 'multiple',
    options: RECIPIENTS_OPTIONS,
    placeholder: 'Sélectionnez les destinataires',
    required: true,
  },
  {
    name: 'deliveryType',
    label: 'Type d\'envoi',
    type: 'select',
    options: [
      { value: DeliveryType.IMMEDIAT, label: 'Immédiat' },
      { value: DeliveryType.PLANIFIE, label: 'Planifié' },
    ],
    required: true,
  },
  {
    name: 'scheduledDate',
    label: 'Date planifiée',
    type: 'date',
    icon: faCalendar,
    required: true,
    showWhen: (values : INotification) => values?.deliveryType === DeliveryType.PLANIFIE,
  },
  {
    name: 'scheduledTime',
    label: 'Heure planifiée',
    type: 'time',
    icon: faClock,
    required: true,
    showWhen: (values : INotification) => values?.deliveryType === DeliveryType.PLANIFIE,
  },
  {
    name: 'channels',
    label: 'Canaux d\'envoi',
    type: 'checkbox',
    options: [
      { value: NotificationChannel.EMAIL, label: 'Email' },
      { value: NotificationChannel.PUSH, label: 'Push' },
      { value: NotificationChannel.SMS, label: 'SMS' },
    ],
    required: true,
  },
  {
    name: 'attachment',
    label: 'Pièce jointe',
    type: 'file',
    icon: faPaperclip,
    accept: '.pdf,.docx,.xlsx,.jpg,.png',
  },
  {
    name: 'message',
    label: 'Message',
    type: 'textarea',
    placeholder: 'Entrez votre message',
    icon: faMessage,
    required: true,
  },
] 