import { Box, Typography, Button, alpha } from "@mui/material"

interface SignatureFieldProps {
  isReadOnly?: boolean
  value?: string
  onChange?: (signature: string) => void
  title?: string
  hasSignature?: boolean
}

export default function SignatureField({
  isReadOnly,
  value,
  onChange,
  title = "Signature electronique",
  hasSignature = true,
}: SignatureFieldProps) {
  return (
    <Box
      sx={{
        border: "1px solid",
        width: "100%",
        borderColor: "primary.main",
        borderRadius: 3,
        pt: 0.5,
        pb: 1,
        px: 1.5,
        bgcolor: (theme) => alpha(theme.palette.primary.main, 0.02),
      }}
    >
      <Typography
        variant="body2"
        sx={{
          color: "primary.main",
          mb: 1,
        }}
      >
        {title}
      </Typography>

      {hasSignature ? (
        <Box
          component="img"
          alt="auth"
          src="/assets/images/mocked_signature.png"
          sx={{
            width: "100%",
            px: "12%",
          }}
        />
      ) : (
        <Box
          sx={{
            width: "100%",
            height: 100,
            px: "12%",
          }}
        />
      )}

      {!isReadOnly ? (
        <Box sx={{ display: "flex", justifyContent: "flex-end" }}>
          <Button variant="contained" size="small" sx={{ bgcolor: "primary.main" }}>
            {hasSignature ? "Mettre à jour" : "Ajouter une signature"}
          </Button>
        </Box>
      ) : <></>}
    </Box>
  )
}

