import { Popover, Box, Typography } from '@mui/material';
import FontAwesome from '@/shared/components/fontawesome';
import {
  faPhone,
  faEnvelope,
  faLocationDot,
  faCar as faCarSolid,
  faWheelchair,
  faMagnifyingGlass,
  faUserTie,
} from '@fortawesome/free-solid-svg-icons';
import { pxToRem } from '@/shared/theme/typography';
import { DriverDetail } from '../types';



interface DriverDetailsPopoverProps {
  anchorEl: HTMLElement | null;
  driver: any;
  onClose: () => void;
}

export const DriverDetailsPopover = ({ anchorEl, driver, onClose }: DriverDetailsPopoverProps) => {
 
  const driverDetails: DriverDetail[] = [
    { icon: faPhone, label: "Num de tel", value: "+1 555 123 4567" },
    { icon: faEnvelope, label: "Email", value: "john.dupont@vsn.com" },
    { icon: faLocationDot, label: "Adresse", value: "1234 Elm Street, Springfield" },
    { icon: faCarSolid, label: "Nombres de places", value: "Toyota Prius (5 places)" },
    { icon: faWheelchair, label: "Fauteuil roulant", value: "Yes" },
    { icon: faMagnifyingGlass, label: "Observation", value: "Usager averti un retard potentiel" },
  ]

  return (
    <Popover
      sx={{
        pointerEvents: 'none',
        '.MuiPopover-paper': {
          borderRadius: 4,
          border: (theme) => `2px solid ${theme.palette.primary.main}`,
        },
      }}
      open={Boolean(anchorEl)}
      anchorEl={anchorEl}
      anchorOrigin={{
        vertical: 'center',
        horizontal: 'right',
      }}
      transformOrigin={{
        vertical: 'top',
        horizontal: 'left',
      }}
      onClose={onClose}
      disableRestoreFocus
    >
      {driver ? (
        <Box sx={{ p: 1, maxWidth: 400 }}>
          <Box
            sx={{ display: 'grid', gridTemplateColumns: 'auto 1fr', gap: '6px', alignItems: 'center' }}
          >
            <Box
              sx={{
                mr: 1,
                width: 28,
                height: 28,
                borderRadius: '50%',
                bgcolor: 'primary.main',
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'center',
              }}
            >
              <FontAwesome icon={faUserTie} color="white" width={14} />
            </Box>

            <Box sx={{ display: 'flex', flexDirection: 'column', justifyContent: 'center' }}>
              <Typography sx={{ fontSize: pxToRem(11) }} fontWeight={600} color="primary.main">
                Nom chauffeur
              </Typography>
              <Typography sx={{ fontSize: pxToRem(11) }}>{driver.name}</Typography>
            </Box>

            {driverDetails.map((detail, index) => (
              <>
                <Box
                  key={`icon-${index}`}
                  sx={{ mr: 1, display: 'flex', justifyContent: 'center', alignItems: 'center' }}
                >
                  <FontAwesome icon={detail.icon} color="primary.main" width={14} />
                </Box>

                <Box
                  key={`content-${index}`}
                  sx={{ display: 'flex', flexDirection: 'column', justifyContent: 'center' }}
                >
                  <Typography sx={{ fontSize: pxToRem(11) }} fontWeight={600} color="primary.main">
                    {detail.label}
                  </Typography>
                  <Typography sx={{ fontSize: pxToRem(11) }}>{detail.value}</Typography>
                </Box>
              </>
            ))}
          </Box>
        </Box>
      ): <></>}
    </Popover>
  );
};
